//
//  ViewController.swift
//  Citizen_PSample_2_Swift
//
//  Created on 2015/08/11.
//  Copyright (c) 2015年 CITIZEN. All rights reserved.
//

import UIKit
import CSJPOSLibSwift

class ViewController: UIViewController, UITextFieldDelegate {

    @IBOutlet weak var editText_Address_Wifi: UITextField!
    @IBOutlet weak var segmentPortType: UISegmentedControl!
    
    var escp: ESCPOSPrinter?
    
    override func viewDidLoad() {
        super.viewDidLoad()
        // Do any additional setup after loading the view, typically from a nib.
        editText_Address_Wifi.returnKeyType = UIReturnKeyType.done
        editText_Address_Wifi.delegate = self
        
        segmentPortType.selectedSegmentIndex = 0
        
        editText_Address_Wifi.text = ""
        
        escp = CSJPOSLibSwift.ESCPOSPrinter()
    }

    override func didReceiveMemoryWarning() {
        super.didReceiveMemoryWarning()
        // Dispose of any resources that can be recreated.
    }

    func messageBox(_ message: String, withTitle title: String, withAutoDismiss dismiss: Bool){
        let alert = UIAlertView()
        alert.title = title
        alert.message = message
        
        if dismiss == true {
            alert.show()
            RunLoop.current.run(until: Date(timeIntervalSinceNow: 1.5))
            alert.dismiss(withClickedButtonIndex: 0, animated: false)
        } else {
            alert.addButton(withTitle: "OK")
            alert.show()
        }
    }
    
    func textFieldShouldReturn(_ textField: UITextField) -> Bool {
        
        editText_Address_Wifi.resignFirstResponder()
        return true
    }
    
    @IBAction func onClick_button_connect(_ sender: AnyObject) {
        
        // get address
        let addr = editText_Address_Wifi.text
        
        // connect
        _ = connect(escp, withConnectType: CMP_PORT_WiFi, withAddress: addr!)
    }

    @IBAction func onClick_button_disconnect(_ sender: AnyObject) {
        
        _ = disconnect(escp)
    }
    
    @IBAction func onClick_button_print(_ sender: AnyObject) {
        
        _ = print(escp)
    }
    
    @IBAction func onClick_button_printerCheck(_ sender: AnyObject) {
        
        _ = printerCheck(escp)
    }
    
    func connect(_ posPtr: AnyObject?, withConnectType connectType: Int32, withAddress addr: String) -> Bool {
        
        var result: Int32 = 0
        var bRet = false
        
        if posPtr == nil {
            
            messageBox("ESCPOSPrinter() : Instance is not created", withTitle: "Error", withAutoDismiss: true)
            return bRet
        }
        
        // connect
        if segmentPortType.selectedSegmentIndex == 0 {
            result = posPtr!.connect(CMP_PORT_BLUETOOTH, withAddrress: addr)
        } else {
            result = posPtr!.connect(CMP_PORT_WiFi, withAddrress: addr)
        }
        
        if CMP_SUCCESS == result {
            bRet = true
            messageBox("connect() : Success", withTitle: "Success", withAutoDismiss: true)
        } else {
            messageBox("Connect() error : \(result)", withTitle: "Error", withAutoDismiss: true)
        }
        
        return bRet
    }
    
    func disconnect(_ posPtr: AnyObject?) -> Bool {
        var result: Int32 = 0
        var bRet = false
        
        if posPtr == nil {
            
            messageBox("ESCPOSPrinter() : Instance is not created", withTitle: "Error", withAutoDismiss: true)
            return bRet
        }
        
        result = posPtr!.disconnect()
        if CMP_SUCCESS == result {
            bRet = true
            messageBox("disconnect() : Success", withTitle: "Success", withAutoDismiss: true)
        } else {
            messageBox("disconnect() error : \(result)", withTitle: "Error", withAutoDismiss: true)
        }
        
        return bRet
    }
    
    func print(_ posPtr: AnyObject?) -> Bool {
        var result: Int32 = 0
        var bRet = false
        
        if posPtr == nil {
            
            messageBox("ESCPOSPrinter() : Instance is not created", withTitle: "Error", withAutoDismiss: true)
            return bRet
        }
        
        // printer check
        result = posPtr!.printerCheck()
        if CMP_SUCCESS != result {
            messageBox("printerCheck() error : \(result)", withTitle: "Error", withAutoDismiss: true)
            return bRet
        }
        
        // get status
        let status = posPtr!.status()
        if CMP_STS_NORMAL != status {
            messageBox("status() error : \(status)", withTitle: "Error", withAutoDismiss: true)
            return bRet
        }
        
        // character set
        
        result = escp!.setEncoding( String.Encoding(rawValue: UInt(String.Encoding.isoLatin1.rawValue)) )
        //result = posPtr!.setEncoding(NSISOLatin1StringEncoding)  // japanese shift-jis
        if CMP_SUCCESS != result {
            messageBox("setEncoding() error : \(result)", withTitle: "Error", withAutoDismiss: true)
            return bRet
        }
        
        // start transaction (batch)
        result = posPtr!.transactionPrint(CMP_TP_TRANSACTION)
        if CMP_SUCCESS != result {
            messageBox("transactionPrint() error : \(result)", withTitle: "Error", withAutoDismiss: true)
            return bRet
        }

        // printText
        let infoDictionary = Bundle.main.localizedInfoDictionary! as Dictionary
        let appName = infoDictionary["CFBundleDisplayName"]! as! String
        let prndata = String("\(appName)\n\n- Sample Print -\n1234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890\n")
        result = posPtr!.printText(prndata, withAlignment:CMP_ALIGNMENT_CENTER, withAttribute:CMP_FNT_DEFAULT, withTextSize:CMP_TXT_1WIDTH|CMP_TXT_1HEIGHT)
        if CMP_SUCCESS != result {
            messageBox("printText() error : \(result)", withTitle: "Error", withAutoDismiss: true)
            _ = posPtr!.clearOutput()
            return bRet
        }
       
        // partical cut with pre-feed
        result = posPtr!.cutPaper(CMP_CUT_PARTIAL_PREFEED)
        if CMP_SUCCESS != result {
            messageBox("cutPaper() error : \(result)", withTitle: "Error", withAutoDismiss: true)
            _ = posPtr!.clearOutput()
            return bRet
        }

        // end transaction (batch)
        result = posPtr!.transactionPrint(CMP_TP_NORMAL)
        if CMP_SUCCESS != result {
            messageBox("transactionPrint() error : \(result)", withTitle: "Error", withAutoDismiss: true)
            _ = posPtr!.clearOutput()
            return bRet
        }
        
        bRet = true

        return bRet
    }
    
    func printerCheck(_ posPtr: AnyObject?) -> Bool {
        
        var result: Int32 = 0
        var bRet = false
        var msg: String? = ""
        
        if posPtr == nil {
            msg = "ESCPOSPrinter() : Instance is not created"
        } else {
            
            // printer check
            result = posPtr!.printerCheck()
            if CMP_SUCCESS == result {
                msg = "\nprinterCheck() : Success\n"
                
                // get status
                let status = posPtr!.status()
                if CMP_STS_NORMAL == status {
                    
                    bRet = true
                    msg = msg! + "\n\t * Normal ( No Error )"
                } else {
                    
                    if (CMP_STS_COVER_OPEN & status) > 0 {
                        msg = msg! + "\n\t * Cover Open"
                    }
                    if (CMP_STS_PAPER_EMPTY & status) > 0 {
                        msg = msg! + "\n\t * Paper Empty"
                    }
                    if (CMP_STS_PRINTEROFF & status) > 0 {
                         msg = msg! + "\n\t * Printer Offline"
                    }
                }
            } else {
                 msg! = "\nprintCheck() error : \(result)"
            }
        }
        
        if msg != nil {
            messageBox(msg!, withTitle: "Status", withAutoDismiss: true)
        }
        
        return bRet
    }
}

